/*****************************************************************************
*  LPC812 blinky program for LPCXpresso board
*
*  1. Use SCT timer to generate a 100 msec toggle output @CTOUT_0
*  2. CTOUT_0 is linked to P0_7 (red LED) and toggles every 100 msec)
*****************************************************************************/

#include "board.h"

#define delay (SystemCoreClock/10)

void sct_fsm_init (void);

void sct_fsm_init (void)
{

	Chip_SCT_Init(LPC_SCT);

	Chip_SCT_Config(LPC_SCT, SCT_CONFIG_32BIT_COUNTER );					/* UNIFIED */


	Chip_SCT_SetMatchCount(LPC_SCT, SCT_MATCH_0, delay);					/* match_0_ */
	Chip_SCT_SetMatchReload(LPC_SCT, SCT_MATCH_0, delay);

	/* OUTPUT registers */

	Chip_SCT_SetOutput(LPC_SCT, SCT_OUTPUT_0, SCT_EVT_0 );  			 	/* Output_pin_0 */
	Chip_SCT_ClearOutput(LPC_SCT, SCT_OUTPUT_0, SCT_EVT_1);


	Chip_SCT_Output(LPC_SCT, SCT_EVT_0);

	/* EVENT registers */

	Chip_SCT_EventState(LPC_SCT, SCT_EVENT_0, ENABLE_STATE0);				/* U: --> state state_1 */
	Chip_SCT_EventControl(LPC_SCT, SCT_EVENT_0, (CHIP_SCT_EVENTCTRL_T)( SCT_EVECTRL_MATCH0	|
                                                                      SCT_COMBMODE_MATCH	|
                                                                      SCT_STATELD_1		    |
                                                                      SCT_STATEEV_1		   ));

	Chip_SCT_EventState(LPC_SCT, SCT_EVENT_1, ENABLE_STATE1);				/* U: --> state U_ENTRY */
	Chip_SCT_EventControl(LPC_SCT, SCT_EVENT_1, (CHIP_SCT_EVENTCTRL_T)( SCT_EVECTRL_MATCH0	|
                                                                      SCT_COMBMODE_MATCH	|
                                                                      SCT_STATELD_1		    |
                                                                      SCT_STATEEV_0		    ));

	LPC_SCT->LIMIT_L = 0x00000003;


	Chip_SCT_ClearControl(LPC_SCT , SCT_CTRL_HALT_L);

}


int main(void)
{
  /* Enter an infinite loop, just incrementing a counter */
    volatile static int i = 0 ;
  
	/* Generic Initialization */
	SystemCoreClockUpdate();
	Board_Init();

	Chip_SWM_Init();								/* Configure the switch matrix    */
	
	Chip_SWM_MovablePinAssign(SWM_CTOUT_0_O, 7);	/* configure the SWM to output CTOUT_0 to PIO0_7 */

	sct_fsm_init();                      			/* Initialize the SCT using the code generated by Red State */


    while(1)
    {
        i++ ;
        __WFI();
    }
}
